import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;


public class Cloud 
{
	private Rectangle box;
	private BufferedImage img;
	private int dir;
	private boolean fallen, dead;
	private double speed, gravity;
	private boolean rising;
	private Font font;

	public Cloud(BufferedImage img, int x, int altitude, int size){
		this.img = img;
		this.dir = 1; // go right
		if(x>0) dir = -1; // go left
		int startX = x-dir*size; //start off screen
		this.box = new Rectangle(startX, altitude, size, (int)(.6*size));
		fallen=false;
		rising=false;
		speed = 1.0+(0.2)*Math.random();
		gravity = .4;
		font = new Font("impact", Font.BOLD, 36);
	}

	public void move(int right, int bottom) {
		if(!fallen && !rising){
			box.x+=(int)(dir*speed);
			fallen = Math.random()<.001; //chance of falling
		}else{

			if (rising){
				box.y-=1;//once hit the cloud rises
			} else {
				box.y+=(int)gravity;
				gravity*=1.005;// 1/2% increase as it falls
			}
		}

		if(dir>0 && box.x > right) dead=true;
		if(dir<0 && box.x+box.width < 0) dead=true;
		if(fallen && box.y+box.height > bottom) {
			dead=true;
		}

		if(rising && box.y+box.height < 0) dead=true;

	}

	public void draw(Graphics g) {
		if(dir>0){
			g.drawImage(img, box.x, box.y, box.x+box.width, box.y+box.height, 0, 0, img.getWidth(), img.getHeight(), null);
		}else{
			g.drawImage(img, box.x, box.y, box.x+box.width, box.y+box.height, img.getWidth(), 0, 0, img.getHeight(), null);
		}
		if(rising){
			g.setColor(Color.RED);
			g.setFont(font);
			g.drawString("100", box.x+box.width/2-25, box.y-20);
		}

	}
	public void hit(){ rising=true;}
	public void setDead(){dead=true;}
	public void setFall() { fallen=true;}
	public boolean isDead() { return dead;}
	public boolean hasFallen() {return fallen;}
	public boolean isRising(){return rising;}
	public Rectangle getBox(){ return box;}
}