import java.applet.AudioClip;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;


public class CloudControler 
{

	private static final int MAX = 10;// number of clouds
	private static final double SPEED = .5;//probability of spawning a cloud
	private BufferedImage img;
	private AudioClip scoreSound;
	private AudioClip damageSound;
	private ArrayList<Cloud> clouds;
	private int right, bottom, score;
	private Chick target;

	public CloudControler(BufferedImage img, AudioClip scoreSound, AudioClip damageSound, 
			int right, int bottom, Chick target) {
		this.img = img;
		this.scoreSound = scoreSound;
		this.damageSound = damageSound;
		clouds = new ArrayList<Cloud>();
		this.right=right;
		this.bottom=bottom;
		this.target = target;
		score = 0;
	}
	public CloudControler(BufferedImage img, int right, int bottom, Chick target) {
		this.img = img;
		this.scoreSound = null;
		this.damageSound = null;
		clouds = new ArrayList<Cloud>();
		this.right=right;
		this.bottom=bottom;
		this.target = target;
		score = 0;
	}
	public void spawn(){
		int x = 0;
		if (Math.random()>.5) x=right;//start of right half the time
		int altitude = randInt(0, 130);
		int size = randInt(60, 150);
		clouds.add(new Cloud(img, x, altitude, size));
	}
	public int randInt(int min, int max){
		return min+(int)(Math.random()*(max-min+1));
	}
	public void draw(Graphics g){
		updateClouds();
		for (Cloud c:clouds)
			c.draw(g);

	}
	public void updateClouds(){
		for (Cloud c:clouds){
			c.move(right, bottom);
			Rectangle cBox = c.getBox();
		    if(target.intersects(cBox) && target.getLife()>0 && !c.isRising()){
			    	if(target.isJumping() && target.isBelow(cBox) ){
			    		score+=100;
			    		c.hit();
			    		if (scoreSound!=null)
        			    		this.scoreSound.play();
			    	}else{	
			    		target.hit(10);
			    		c.setDead();
			    		if (damageSound!=null)
            			    		this.damageSound.play();
			    	}
		    }	    
		}
		//Check for dead clouds
		int i=0;
		while(i< clouds.size()){
			Cloud c = clouds.get(i);
			if (c.isDead()) {
				if (!c.isRising() && target.getLife()>0) score+=10;
				clouds.remove(i);
			}
			else i++;
		}
		if (clouds.size()<MAX && Math.random()<SPEED){
			spawn();
		}
	}
	public String getScore(){ return String.format("%,10d", score) ;}
}