import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ChickenLittleApp extends JPanel implements KeyListener, ActionListener
{
     /**
	 * Adaptation of my Chicken Little Applet from 2013
	 * This version currently has no sounds
	 * @author Chris Thiel
	 * @version May 14, 2022
	 */
    public static int BOTTOM=600, TOP=0, LEFT=0, RIGHT=800;
    private BufferedImage sky, chickImg, cloudImg;
    //private AudioClip bell,squish; // no sound for now
    private Chick chick;
    private String message;
    private CloudControler weather;
    private Font font;
    private Font bigFont;
    private Timer refresh;

    public ChickenLittleApp(){
        
        this.loadResources();
        message="Arrow keys to move (or a,s), space to jump (or w)";
        chick = new Chick(chickImg, (RIGHT-LEFT-60)/2, BOTTOM);
        weather = new CloudControler(cloudImg, RIGHT, BOTTOM, chick);
        addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        refresh = new Timer(5, this); // lower is faster pace
        refresh.start();
        font = new Font("helvetica", Font.BOLD, 12);
        bigFont = new Font("Impact", Font.BOLD, 24);
    }

    public void paintComponent(Graphics g){
        super.paintComponent(g);
        g.drawImage(sky, LEFT, TOP, null);
        chick.draw(g);
        weather.draw(g);
        drawInfo(g);
        //g.drawImage(screen2, 0,0,this);
        //g.dispose();
        this.requestFocus();
        //repaint();
    }

    public void drawInfo(Graphics g){		
        int life = chick.getLife();
        g.setColor(Color.GREEN);
        if(life <= 30) g.setColor(Color.RED);
        g.fillRect(410, 5, life, 20);
        g.setColor(Color.BLUE);
        g.setFont(font);
        g.drawString(message, 20, 20);
        g.drawRect(410, 5, 100, 20);	
        g.setColor(Color.BLACK);
        g.setFont(bigFont);
        g.drawString("Score: "+weather.getScore(), 570, 25);
        g.drawString("Life: "+life, 325, 25);

    }
    public static void main(String[] args)
    {
        ChickenLittleApp app = new ChickenLittleApp();
        JFrame window = new JFrame("Chicken Little");
        window.setSize(RIGHT, BOTTOM+30);
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.getContentPane().add(app);
        window.addKeyListener(app);
        window.setVisible(true);
    }
    public void loadResources(){
        //We load the large files once to save time,
        //getting the resource from the jar file
        try {
            cloudImg = ImageIO.read( getClass().getResource("/Cloud.png"));
            chickImg = ImageIO.read( getClass().getResource("/Chick.png"));
            sky = ImageIO.read( getClass().getResource("/sky.png"));
            //bell = audio.getAudioClip(getClass().getResource("/bell.wav"));
            //squish = audio.getAudioClip(getClass().getResource("/squish.wav"));

        } catch (Exception e) {
            e.printStackTrace();// the graphics files were not found
        }

    }
    public void actionPerformed(ActionEvent e) {
        if(e.getSource()==refresh)
             repaint();
    }


    @Override
    public void keyTyped(KeyEvent e) {}

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == KeyEvent.VK_LEFT || code== KeyEvent.VK_A){
            chick.setDx(-1);
        } 
        if (code == KeyEvent.VK_RIGHT || code == KeyEvent.VK_S){
            chick.setDx(1);
        }
        if (code == KeyEvent.VK_SPACE || code == KeyEvent.VK_W || code == KeyEvent.VK_UP){
            //jump
            chick.setDy(3);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == KeyEvent.VK_LEFT || code== KeyEvent.VK_A ||
        code == KeyEvent.VK_RIGHT || code == KeyEvent.VK_S	) chick.setDx(0);
    }
}