import com.pi4j.wiringpi.*;
/**
 * This class represents a PWM LED connected to the Raspberry pi on a given pin (default pin 25)
 * (PWM=Pulse-width modulation is a way to control DC motor speeds as well as LED brightness)
 * Connect the physical LED to a GND pin and to a GPIO pin.
 */
public class pwmLED
{
    
    private int value;
    private int pinNumber;
    
    /**
     * Constructor
     */
   
    /**
     * specifi a WPi pin number - not this is not the same as the BCM GPIO number or the 
     * physical pin number type $gpio readall in a terminal to get the mapping of pins
     * for you model of RaspberyyPi
     * 
     */
    public pwmLED(int pin)
    {
        Gpio.wiringPiSetup();
        this.pinNumber = pin;
        SoftPwm.softPwmCreate(pin,0,100);
        value = 0;
        SoftPwm.softPwmWrite(pin, value);
    }
    
    /**
     * Set the LED value, valid values are integers from 0 to 100, inclusive.
     * 
     */
    public void setValue(int v)
    {
        //checks if the desired value is valid. if so, proceed.
        if (v >= 0 && v <= 100){
            value = v;
            SoftPwm.softPwmWrite(pinNumber, value);
        }
    }
    
    /**
     * Returns the current value of the LED.
     * @return integer from 0 to 100 with the LED current value.
     * 
     */
    public int getValue()
    {
        return value;
    }
    public void on() 
    { 
        setValue(100);
    }
    public void off() 
    { 
        setValue(0);
    }
    public boolean isOn(){
        return value>0;
    }
}
