/*
 * Decompiled with CFR 0.152.
 */
public class Game {
    private Grid grid = new Grid(20, 5);
    private int userCol = 0;
    private int msElapsed = 0;
    private int timesGet = 5;
    private int timesAvoid = 0;

    public Game() {
        this.updateTitle();
        this.grid.setImage(new Location(19, this.userCol), "My Ship.png");
    }

    public void play() {
        while (!this.isGameOver()) {
            Grid.pause(100);
            this.handleKeyPress();
            if (this.msElapsed % 300 == 0) {
                this.scrollDown();
                this.populateTopEdge();
            }
            this.updateTitle();
            this.msElapsed += 100;
        }
    }

    public void handleKeyPress() {
        Location loc = new Location(19, this.userCol);
        int key = this.grid.checkLastKeyPressed();
        if (key == 37) {
            this.userCol = Math.max(this.userCol - 1, 0);
        }
        if (key == 39) {
            this.userCol = Math.min(this.userCol + 1, this.grid.getNumCols() - 1);
        }
        Location next = new Location(19, this.userCol);
        this.handleCollision(next);
        this.grid.setImage(loc, null);
        this.grid.setImage(next, "My Ship.png");
    }

    public void handleKeyPressWRONG() {
        Location loc = new Location(this.userCol, 0);
        int key = this.grid.checkLastKeyPressed();
        if (key == 38) {
            this.userCol = Math.max(this.userCol - 1, 0);
        }
        if (key == 40) {
            this.userCol = Math.min(this.userCol + 1, this.grid.getNumRows() - 1);
        }
        Location next = new Location(this.userCol, 0);
        this.handleCollision(next);
        this.grid.setImage(loc, null);
        this.grid.setImage(next, "user.gif");
    }

    public void populateTopEdge() {
        int row = 1;
        int n = (int)(3.0 * Math.random());
        int bulletHellMode = 6;
        int i = 0;
        while (i < n) {
            int c = (int)((double)this.grid.getNumCols() * Math.random());
            Location loc = new Location(row - 1, c);
            this.grid.setImage(loc, "Blaze_Powder.png");
            ++i;
        }
    }

    public void scrollLeft() {
        int r = 0;
        while (r < this.grid.getNumRows()) {
            Location next = new Location(r, 1);
            if (r != this.userCol) {
                this.grid.setImage(new Location(r, 0), this.grid.getImage(next));
                this.grid.setImage(next, null);
            } else {
                this.handleCollision(next);
            }
            ++r;
        }
        int c = 1;
        while (c < this.grid.getNumCols() - 1) {
            int r2 = 0;
            while (r2 < this.grid.getNumRows()) {
                Location loc = new Location(r2, c + 1);
                String img = this.grid.getImage(loc);
                Location next = new Location(r2, c);
                this.grid.setImage(next, img);
                ++r2;
            }
            ++c;
        }
        r = 0;
        while (r < this.grid.getNumRows()) {
            this.grid.setImage(new Location(r, this.grid.getNumCols() - 1), null);
            ++r;
        }
    }

    public void scrollDown() {
        int c = 0;
        while (c < this.grid.getNumCols()) {
            Location next = new Location(this.grid.getNumRows() - 1, c);
            if (c != this.userCol) {
                this.grid.setImage(new Location(this.grid.getNumRows() - 1, c), this.grid.getImage(next));
                this.grid.setImage(next, null);
            } else {
                this.handleCollision(next);
            }
            ++c;
        }
        int r = this.grid.getNumRows() - 2;
        while (r >= 0) {
            int c2 = 0;
            while (c2 < this.grid.getNumCols()) {
                Location loc = new Location(r, c2);
                String img = this.grid.getImage(loc);
                Location next = new Location(r + 1, c2);
                this.grid.setImage(next, img);
                ++c2;
            }
            --r;
        }
        c = this.grid.getNumCols() - 1;
        while (c >= 0) {
            this.grid.setImage(new Location(0, c), null);
            --c;
        }
    }

    public void handleCollision(Location loc) {
        String img = this.grid.getImage(loc);
        if (img == null) {
            return;
        }
        if (img.equals("Blaze_Powder.png")) {
            ++this.timesAvoid;
        }
        this.grid.setImage(loc, null);
    }

    public int getScore() {
        return 10 * this.timesGet - 5 * this.timesAvoid;
    }

    public void updateTitle() {
        this.grid.setTitle("Game:  " + this.getScore() + " Hits:" + this.timesAvoid + " Points:" + this.timesGet);
    }

    public boolean isGameOver() {
        return this.getScore() <= 0;
    }

    public static void test() {
        Game game = new Game();
        game.play();
    }

    public static void main(String[] args) {
        Game.test();
    }
}

