package com.mathorama.joust;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
/**
 * An Application to hold the Joust Board
 * and deal with user input
 * Free for educational use.
 * @author Chris Thiel, OFMCap
 * Applet version 30 Sept 2012
 * @version 9 April 2020 
 */

@SuppressWarnings("serial")
public class Joust extends JPanel implements MouseMotionListener, MouseListener
{
  
	/**
     * Instance fields for the Game
     *
     */
    private Board board;
    private Rectangle restartBtn;
    private Font font, smFont;//The font for our messages
    private String message;
    private static int WIDE=950;
    private static int TALL=680;

    public Joust()
    {

        board=new Board(8,8, 50, 50);

        this.restartBtn = new Rectangle (700, 350, 100, 35);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        
        font = new Font(Font.SANS_SERIF, Font.PLAIN,  24);
        smFont = new Font(Font.SANS_SERIF, Font.PLAIN,  18);  
        message="Joust! "+"White"+"'s move";
        
    }
    public static void main(String[] args)
    {
    	Joust app =  new Joust();
        JFrame window = new JFrame("Joust");
        window.setSize(WIDE, TALL);
        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.getContentPane().add(app);
        window.setVisible(true);
    }
    

    public void paintComponent (Graphics g)
    {
        super.paintComponent(g);
    
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        g.setFont(smFont);
        g.drawString("Each square can only be visited", 650, TALL/3);
        g.drawString("once.", 650, TALL/3+ 20);
        g.drawString("Win by leaving your opponent", 650, TALL/3+ 50);
        
        g.drawString("without any possible moves.", 650, TALL/3+ 70);
        g.setColor(Color.BLUE);
        g.setFont(font);
        g.drawString(message, 650, 55);
        g.drawString(board.getMessage2(), 650, 85);
        g.drawString(board.getMessage1(), 650, 115);
        if ( board.gameOver()){
            g.setColor(Color.BLUE);
            g.fillRect(restartBtn.x, restartBtn.y, restartBtn.width, restartBtn.height);
            g.setColor(Color.YELLOW);
            g.drawString("Restart", restartBtn.x+10, restartBtn.y+25);
        }
        board.draw(g);
        drawLabels(g,board);

        //g.drawImage(virtualMem,0,0,this);//set new display to Screen
    }
    public void drawLabels(Graphics g, Board b)
    {
    	int size = b.getSquareSize();
    	int rows = b.getNumRows();
    	int cols = b.getNumCols();
    	int x = b.getLeft();
    	int y = b.getTop();
    	g.setFont(smFont);
    	for (int i = 0; i < rows; i++ )
    	{
    		g.drawString(""+(8-i), x-20, 10+y+i*size+size/2);
    		g.drawString(""+(8-i), x+8*size+10, 10+y+i*size+size/2);
    	}
    	for (int i = 0; i < cols; i++ )
    	{
    		g.drawString("abcdefgh".substring(i, i+1), x+i*size+size/2, y-9);
    		g.drawString("abcdefgh".substring(i, i+1), x+i*size+size/2, y+cols*size+18);
    	}
    }
   
    public void mouseClicked(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) 
    {
        board.move();
        if(board.gameOver()){
            if (restartBtn.contains(e.getPoint())){
                board=new Board(8,8, 50, 50);
                repaint();
            }
        }
        repaint();
    }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
        int x=e.getX();
        int y=e.getY();

        board.setHighlight(x, y);
        message=board.whoseTurn();
        repaint();
    }

   

}