package com.mathorama.joust;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class Knight {
	/**
	 * instance fields
	 */

	private int row, col;
	private Color color;
	public static final String KNIGHT_OUTLINE="\u2658"; //the unicode outline knight letter
	public static final String KNIGHT="\u265e"; //the unicode filled knight letter
	/**
	 * constructors
	 */
	public Knight() {
		color=Color.WHITE;
		row=0;
		col=0;
	}

	public Knight(String color){
		this(); //use default constructor to initialize fields
		if (color.equals("black") )
			this.color=Color.BLACK;		
	}

	public Knight(String color, int row, int col){
		this(color); //use other constructor to initialize fields
		this.row=row;
		this.col=col;
	}

	public void draw(Graphics g, Board board){
		int size = board.getSquareSize();
		int offset = (int)(size/5.0);
		int x=board.getLeft()+col*size;
		int y=board.getTop()+(row)*size;

		Font font=new Font("Arial Unicode MS", 0, size);//Arial is the most complete for Win

		g.setFont(font);
		g.setColor(color);
		g.drawString(KNIGHT, x, y+size-offset);  
		if (isWhite())
		{
			g.setColor(Color.BLACK);
			g.drawString(KNIGHT_OUTLINE, x, y+size-offset);  
		}
	}

	public boolean isWhite()
	{
		return color==Color.WHITE;
	}

	public boolean isBlack()
	{
		return !isWhite();
	}

	public int getRow() {
		return row;
	}

	public void setRow(int row) {
		this.row = row;
	}

	public int getCol() {
		return col;
	}

	public void setCol(int col) {
		this.col = col;
	}

	public Color getColor(){
		return color;
	}

	public void setColor(Color color){
		this.color=color;
	}



}