/*
 * Decompiled with CFR 0.152.
 */
package com.mathorama.joust;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Square {
    public static final int black = 0;
    public static final int white = 1;
    public static final int burned = 2;
    private Color[] colors = new Color[3];
    private int color;
    private boolean highlighted;
    private Rectangle box;

    public Square() {
        this.colors[0] = new Color(208, 145, 145);
        this.colors[1] = new Color(243, 219, 219);
        this.colors[2] = new Color(100, 0, 0);
        this.setColor(1);
        this.setHighlighted(false);
        this.box = null;
    }

    public Square(int color) {
        this();
        this.setColor(color);
    }

    public Square(int color, Rectangle box) {
        this();
        this.setColor(color);
        this.box = box;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void draw(Graphics g) {
        if (this.box == null) {
            return;
        }
        int w = 2;
        int x = (int)this.box.getX();
        int y = (int)this.box.getY();
        int size = (int)this.box.getHeight();
        if (this.highlighted) {
            g.setColor(Color.MAGENTA);
        } else {
            g.setColor(Color.BLACK);
        }
        g.fillRect(x, y, size, size);
        g.setColor(this.colors[this.color]);
        g.fillRect(x + w, y + w, size - 2 * w, size - 2 * w);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public Square select(int x, int y) {
        this.setHighlighted(this.box.contains(x, y));
        if (this.isHighlighted()) {
            return this;
        }
        return null;
    }

    public boolean isBurned() {
        return this.color == 2;
    }
}

