/*
 * Decompiled with CFR 0.152.
 */
package com.mathorama.joust;

import com.mathorama.joust.Knight;
import com.mathorama.joust.Square;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Board {
    private int squareSize;
    private int top;
    private int left;
    private Square[][] grid;
    private Square selectedSquare;
    private int selectedRow;
    private int selectedCol;
    private Knight[] player;
    private Knight currentPlayer;
    private String message1;
    private String message2;

    public Board(int rows, int cols, int top, int left) {
        this.setSquareSize(70);
        this.grid = new Square[rows][cols];
        this.setTop(top);
        this.setLeft(left);
        this.setSelectedSquare(null);
        this.setSelectedRow(-1);
        this.setSelectedCol(-1);
        this.setMessage1("White's turn");
        this.setMessage2("Joust");
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int color = (r + c + 1) % 2;
                int x = left + c * this.squareSize;
                int y = top + r * this.squareSize;
                Rectangle rectangle = new Rectangle(x, y, this.squareSize, this.squareSize);
                this.grid[r][c] = new Square(color, rectangle);
                ++c;
            }
            ++r;
        }
        this.player = new Knight[2];
        int rand = (int)((double)this.getNumCols() * Math.random());
        this.player[0] = new Knight("white", this.getNumRows() - 1, rand);
        rand = (int)((double)this.getNumCols() * Math.random());
        this.player[1] = new Knight("black", 0, rand);
        this.setCurrentPlayer(this.player[0]);
    }

    public int getNumRows() {
        return this.grid.length;
    }

    public int getNumCols() {
        return this.grid[0].length;
    }

    public Square getSquare(int row, int col) {
        return this.grid[row][col];
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public void setSquareSize(int squareSize) {
        this.squareSize = squareSize;
    }

    public Knight getCurrentPlayer() {
        return this.currentPlayer;
    }

    public boolean isAvailable(int r, int c) {
        if (r < 0 || c < 0 || r >= this.getNumRows() || c >= this.getNumCols()) {
            return false;
        }
        if (this.grid[r][c].isBurned()) {
            return false;
        }
        int i = 0;
        while (i < 2) {
            if (this.player[i].getRow() == r && this.player[i].getCol() == c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setCurrentPlayer(Knight currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public String getMessage1() {
        return this.message1;
    }

    public String getMessage2() {
        return this.message2;
    }

    public void setMessage1(String message) {
        this.message1 = message;
    }

    public void setMessage2(String message) {
        this.message2 = message;
    }

    public Square getSelectedSquare() {
        return this.selectedSquare;
    }

    public void setSelectedSquare(Square selectedSquare) {
        this.selectedSquare = selectedSquare;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        this.selectedRow = selectedRow;
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    public void setSelectedCol(int selectedCol) {
        this.selectedCol = selectedCol;
    }

    public void draw(Graphics g) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.grid[r][c].draw(g);
                ++c;
            }
            ++r;
        }
        this.player[0].draw(g, this);
        this.player[1].draw(g, this);
    }

    public void setHighlight(int x, int y) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Square s = this.grid[r][c].select(x, y);
                if (s != null) {
                    this.setSelectedSquare(s);
                    this.setSelectedRow(r);
                    this.setSelectedCol(c);
                }
                ++c;
            }
            ++r;
        }
        this.message1 = this.getAlgebraicNotation(this.currentPlayer.getRow(), this.currentPlayer.getCol());
        this.message2 = "(" + this.currentPlayer.getRow() + ", " + this.currentPlayer.getCol() + ") ";
        if (this.selectedRow < 0 || this.selectedCol < 0 || this.selectedRow > this.grid.length - 1 || this.selectedCol > this.grid[0].length - 1) {
            return;
        }
        this.message1 = String.valueOf(this.message1) + " to " + this.getAlgebraicNotation(this.selectedRow, this.selectedCol) + " is ";
        this.message2 = String.valueOf(this.message2) + " to (" + this.selectedRow + ", " + this.selectedCol + ") ";
        this.message1 = this.isLegalMove(this.currentPlayer, this.selectedRow, this.selectedCol) ? String.valueOf(this.message1) + "legal" : String.valueOf(this.message1) + "NOT legal";
    }

    public String getSelected() {
        return "(" + this.selectedRow + ", " + this.selectedCol + ")";
    }

    public String getAlgebraicNotation(int row, int col) {
        return String.valueOf("abcdefgh".charAt(col)) + (8 - row);
    }

    public String whoseTurn() {
        if (!this.gameOver() && this.currentPlayer.isWhite()) {
            return "White's turn";
        }
        if (!this.gameOver() && this.currentPlayer.isBlack()) {
            return "Black's turn";
        }
        if (this.hasMovesLeft(this.player[0])) {
            return "White wins";
        }
        return "Black Wins";
    }

    public void move() {
        if (this.gameOver()) {
            return;
        }
        if (this.isLegalMove(this.currentPlayer, this.selectedRow, this.selectedCol)) {
            this.grid[this.currentPlayer.getRow()][this.currentPlayer.getCol()].setColor(2);
            this.currentPlayer.setRow(this.selectedRow);
            this.currentPlayer.setCol(this.selectedCol);
            if (!this.gameOver()) {
                this.currentPlayer = this.currentPlayer == this.player[0] ? this.player[1] : this.player[0];
            }
        }
        this.message1 = this.whoseTurn();
    }

    public boolean gameOver() {
        int i = 0;
        while (i < 2) {
            if (!this.hasMovesLeft(this.player[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLegalMove(Knight player, int r, int c) {
        if (this.grid[r][c].isBurned()) {
            return false;
        }
        Knight[] knightArray = this.player;
        int n = this.player.length;
        int n2 = 0;
        while (n2 < n) {
            Knight k = knightArray[n2];
            if (k.getRow() == r && k.getCol() == c) {
                return false;
            }
            ++n2;
        }
        int deltaX = Math.abs(player.getRow() - r);
        int deltaY = Math.abs(player.getCol() - c);
        if (deltaX == 0 || deltaY == 0) {
            return false;
        }
        return deltaX + deltaY == 3;
    }

    public boolean hasMovesLeft(Knight player) {
        int r = 0;
        while (r < 8) {
            int c = 0;
            while (c < 8) {
                if (this.isLegalMove(player, r, c)) {
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }
}

