import java.awt.*;

public class PackMan
{
    // instance variables - replace the example below with your own
    private int x, y, size, direction;
    private Level lev;
    private Cell myCell;
    private boolean isOpen;
    public static final int SPEED = 10;
    /**
     * Constructor for objects of class PackMan
     */
    public PackMan(Level lev, int row, int col)
    {
        this.lev = lev;
        this.size = lev.getSize()-10;
        this.x = lev.getXbyCol(col);
        this.y = lev.getYbyRow(row);
        this.myCell = lev.getCell(x,y);
        isOpen = false;
        direction = Cell.SOUTH;
        lev.getCell(x, y).setVisited(true);
    }

    public void setDirection(int dir)
    {
        direction = dir;
    }
    public void changeMouth()
    {
        isOpen = !isOpen;
    }
    public void move(){
        int nextX = this.x;
        int nextY = this.y;
        if (direction == Cell.NORTH)
            nextY = y - SPEED;
        else if (direction == Cell.SOUTH)
            nextY = y + SPEED;
        else if (direction == Cell.EAST)
            nextX = x + SPEED;
        else if (direction == Cell.WEST)
            nextX = x - SPEED;
        Cell nextCell = lev.getCell(nextX, nextY);  
        if (myCell.canExit(direction))
        {
            this.x = nextX;
            this.y = nextY;
            this.myCell.setVisited(true);
        }
        if (myCell != nextCell){
            myCell = nextCell;
            this.x = myCell.getX();
            this.y = myCell.getY();
        }
        
        
    }
    public Cell getCell(){ return myCell; }
    public int getDirection() {return direction;}
    public void draw(Graphics g)
    {
        g.setColor(Color.YELLOW);
        int x0 = x - size/2;
        int y0 = y - size/2;
        if( isOpen )
           g.fillOval(x0,y0,size,size);
        else if (direction == Cell.EAST)
        {
             g.fillArc(x0,y0,size,size, 45,270 );
        }else if (direction == Cell.NORTH)
        {
             g.fillArc(x0,y0,size,size, 135,270 );
        }else if (direction == Cell.WEST)
        {
             g.fillArc(x0,y0,size,size, 225,270 );
        }else if (direction == Cell.SOUTH)
        {
             g.fillArc(x0,y0,size,size, -45,270 );
        }
        
    }
    public String toString(){
        String result = "Pacman: ("+x+", "+y+") facing ";
        if(direction == Cell.NORTH) 
            result += "N ";
        if(direction == Cell.SOUTH) 
            result += "S ";
        if(direction == Cell.EAST) 
            result += "E ";
        if(direction == Cell.WEST) 
            result += "W ";
        result += myCell.toString()+ " can ";
        if (!myCell.canExit(direction))
            result += "NOT ";
        result += "exit.";    
        return result;
    }
}
