/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import java.util.EnumSet;

public enum PinDirection {
    IN(0, "in"),
    OUT(1, "out");

    private final int value;
    private final String name;

    private PinDirection(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static PinDirection getDirection(int direction) {
        for (PinDirection item : PinDirection.values()) {
            if (item.getValue() != direction) continue;
            return item;
        }
        return null;
    }

    public static EnumSet<PinDirection> all() {
        return EnumSet.allOf(PinDirection.class);
    }
}

