/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.RaspiPinNumberingScheme;
import com.pi4j.io.gpio.WiringPiGpioProviderBase;
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterruptListener;

public class RaspiGpioProvider
extends WiringPiGpioProviderBase
implements GpioProvider,
GpioInterruptListener {
    public static final String NAME = "RaspberryPi GPIO Provider";

    public RaspiGpioProvider() {
        this(RaspiPinNumberingScheme.DEFAULT_PIN_NUMBERING);
    }

    public RaspiGpioProvider(RaspiPinNumberingScheme pinNumberingScheme) {
        switch (pinNumberingScheme) {
            case BROADCOM_PIN_NUMBERING: {
                Gpio.wiringPiSetupGpio();
                break;
            }
            case DEFAULT_PIN_NUMBERING: {
                Gpio.wiringPiSetup();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported pin numbering scheme: " + pinNumberingScheme.name());
            }
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

