/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import java.util.Map;

public class SimulatedGpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static String NAME;

    public SimulatedGpioProvider() {
        Map<String, String> env = System.getenv();
        String config = env.get("SimulatedPlatform");
        if (config == null) {
            NAME = "RaspberryPi GPIO Provider";
            return;
        }
        NAME = config;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setState(Pin pin, PinState state) {
        this.getPinCache(pin).setState(state);
        this.dispatchPinDigitalStateChangeEvent(pin, state);
    }

    public void setAnalogValue(Pin pin, double value) {
        this.getPinCache(pin).setAnalogValue(value);
        this.dispatchPinAnalogValueChangeEvent(pin, value);
    }
}

