/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.wdt.impl;

import com.pi4j.io.wdt.WDTimer;
import com.pi4j.jni.WDT;
import java.io.IOException;

public final class WDTimerImpl
implements WDTimer {
    private static final WDTimerImpl instance = new WDTimerImpl();
    private int fd = -1;
    private String filename;

    public static WDTimer getInstance() {
        return instance;
    }

    @Override
    public void open() throws IOException {
        this.open("/dev/watchdog");
    }

    public void open(String file) throws IOException {
        this.filename = file;
        if (this.fd > 0) {
            throw new IOException("File " + this.filename + " already open.");
        }
        this.fd = WDT.open(file);
        if (this.fd < 0) {
            throw new IOException("Cannot open file handle for " + this.filename + " got " + this.fd + " back.");
        }
    }

    @Override
    public void setTimeOut(int timeout) throws IOException {
        this.isOpen();
        int ret = WDT.setTimeOut(this.fd, timeout);
        if (ret < 0) {
            throw new IOException("Cannot set timeout for " + this.filename + " got " + ret + " back.");
        }
    }

    @Override
    public int getTimeOut() throws IOException {
        this.isOpen();
        int ret = WDT.getTimeOut(this.fd);
        if (ret < 0) {
            throw new IOException("Cannot read timeout for " + this.filename + " got " + ret + " back.");
        }
        return ret;
    }

    @Override
    public void heartbeat() throws IOException {
        this.isOpen();
        int ret = WDT.ping(this.fd);
        if (ret < 0) {
            throw new IOException("Heartbeat error. File " + this.filename + " got " + ret + " back.");
        }
    }

    @Override
    public void disable() throws IOException {
        this.isOpen();
        int ret = WDT.disable(this.fd);
        if (ret < 0) {
            throw new IOException("Cannot disable WatchDog.  File " + this.filename + " got " + ret + " back.");
        }
    }

    @Override
    public void close() throws IOException {
        this.isOpen();
        int ret = WDT.close(this.fd);
        if (ret < 0) {
            throw new IOException("Close file " + this.filename + " got " + ret + " back.");
        }
        this.fd = -1;
    }

    private void isOpen() throws IOException {
        if (this.fd < 0) {
            throw new IOException("Watchdog is not open yet");
        }
    }
}

