/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.jni;

import com.pi4j.jni.SerialInterruptEvent;
import com.pi4j.jni.SerialInterruptListener;
import com.pi4j.util.NativeLibraryLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerialInterrupt {
    private static Map<Integer, SerialInterruptListener> listeners = new ConcurrentHashMap<Integer, SerialInterruptListener>();

    private SerialInterrupt() {
    }

    public static native int enableSerialDataReceiveCallback(int var0);

    public static native int disableSerialDataReceiveCallback(int var0);

    private static void onDataReceiveCallback(int fileDescriptor, byte[] data) {
        SerialInterruptListener listener;
        if (listeners.containsKey(fileDescriptor) && (listener = listeners.get(fileDescriptor)) != null) {
            SerialInterruptEvent event = new SerialInterruptEvent(listener, fileDescriptor, data);
            listener.onDataReceive(event);
        }
    }

    public static synchronized void addListener(int fileDescriptor, SerialInterruptListener listener) {
        if (!listeners.containsKey(fileDescriptor)) {
            listeners.put(fileDescriptor, listener);
            SerialInterrupt.enableSerialDataReceiveCallback(fileDescriptor);
        }
    }

    public static synchronized void removeListener(int fileDescriptor) {
        if (listeners.containsKey(fileDescriptor)) {
            listeners.remove(fileDescriptor);
            SerialInterrupt.disableSerialDataReceiveCallback(fileDescriptor);
        }
    }

    public static synchronized boolean hasListener(int fileDescriptor) {
        return listeners.containsKey(fileDescriptor);
    }

    static {
        NativeLibraryLoader.load("libpi4j.so", "pi4j");
    }
}

