/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.wiringpi;

import com.pi4j.util.NativeLibraryLoader;
import com.pi4j.wiringpi.GpioInterruptCallback;
import java.util.ArrayList;
import java.util.List;

public class Gpio {
    public static final int NUM_PINS = 46;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int PWM_OUTPUT = 2;
    public static final int GPIO_CLOCK = 3;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int PUD_OFF = 0;
    public static final int PUD_DOWN = 1;
    public static final int PUD_UP = 2;
    public static final int PWM_MODE_BAL = 1;
    public static final int PWM_MODE_MS = 0;
    public static final int ALT0 = 4;
    public static final int ALT1 = 5;
    public static final int ALT2 = 6;
    public static final int ALT3 = 7;
    public static final int ALT4 = 3;
    public static final int ALT5 = 2;
    public static final int INT_EDGE_SETUP = 0;
    public static final int INT_EDGE_FALLING = 1;
    public static final int INT_EDGE_RISING = 2;
    public static final int INT_EDGE_BOTH = 3;
    private static List<GpioInterruptCallback>[] isrCallbacks;

    private Gpio() {
    }

    public static native int wiringPiSetup();

    public static native int wiringPiSetupSys();

    public static native int wiringPiSetupGpio();

    public static native int wiringPiSetupPhys();

    public static native void pinMode(int var0, int var1);

    public static native void pinModeAlt(int var0, int var1);

    public static native void pullUpDnControl(int var0, int var1);

    public static native void digitalWrite(int var0, int var1);

    public static void digitalWrite(int pin, boolean value) {
        Gpio.digitalWrite(pin, value ? 1 : 0);
    }

    public static native void pwmWrite(int var0, int var1);

    public static native int digitalRead(int var0);

    public static native int analogRead(int var0);

    public static native void analogWrite(int var0, int var1);

    public static native void delay(long var0);

    public static native long millis();

    public static native long micros();

    public static native void delayMicroseconds(long var0);

    public static native int piHiPri(int var0);

    public static native int waitForInterrupt(int var0, int var1);

    public static int wiringPiISR(int pin, int edgeType, GpioInterruptCallback callback) {
        if (isrCallbacks[pin] == null) {
            Gpio.isrCallbacks[pin] = new ArrayList<GpioInterruptCallback>();
        }
        isrCallbacks[pin].add(callback);
        return Gpio._wiringPiISR(pin, edgeType);
    }

    private static native int _wiringPiISR(int var0, int var1);

    public static void wiringPiClearISR(int pin) {
        if (isrCallbacks[pin] != null) {
            isrCallbacks[pin].clear();
        }
    }

    private static void isrCallback(int pin) {
        List<GpioInterruptCallback> callbacks = isrCallbacks[pin];
        if (callbacks != null && !callbacks.isEmpty()) {
            for (GpioInterruptCallback callback : callbacks) {
                callback.callback(pin);
            }
        }
    }

    public static native int piBoardRev();

    public static native int wpiPinToGpio(int var0);

    public static native int physPinToGpio(int var0);

    public static native void digitalWriteByte(int var0);

    public static native void pwmSetMode(int var0);

    public static native void pwmSetRange(int var0);

    public static native void pwmSetClock(int var0);

    public static native void setPadDrive(int var0, int var1);

    public static native int getAlt(int var0);

    public static native void gpioClockSet(int var0, int var1);

    static {
        NativeLibraryLoader.load("libpi4j.so", "pi4j");
        isrCallbacks = new List[46];
    }
}

