/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.concurrent;

import com.pi4j.concurrent.DefaultExecutorServiceFactory;
import com.pi4j.concurrent.ShutdownDisabledExecutorWrapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SingleThreadGpioExecutorServiceFactory
extends DefaultExecutorServiceFactory {
    private static ExecutorService getInternalGpioExecutorService() {
        return GpioEventExecutorServiceHolder.heldExecutor;
    }

    private static ExecutorService getGpioEventExecutorServiceWrapper() {
        return GpioEventExecutorServiceWrapperHolder.heldWrapper;
    }

    @Override
    public ExecutorService getGpioEventExecutorService() {
        return SingleThreadGpioExecutorServiceFactory.getGpioEventExecutorServiceWrapper();
    }

    @Override
    public void shutdown() {
        this.shutdownExecutor(SingleThreadGpioExecutorServiceFactory.getInternalGpioExecutorService());
        super.shutdown();
    }

    private static class GpioEventExecutorServiceWrapperHolder {
        static final ExecutorService heldWrapper = new ShutdownDisabledExecutorWrapper(SingleThreadGpioExecutorServiceFactory.getInternalGpioExecutorService());

        private GpioEventExecutorServiceWrapperHolder() {
        }
    }

    private static class GpioEventExecutorServiceHolder {
        static final ExecutorService heldExecutor = Executors.newSingleThreadExecutor(DefaultExecutorServiceFactory.getThreadFactory("pi4j-gpio-event-executor-%d"));

        private GpioEventExecutorServiceHolder() {
        }
    }
}

